/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
/*
TRUTHTABLE     : 

          ----------------------------
          D    clk   clrn  prn ena  q
          ----------------------------
                 
          X     X     H    H   L    q0  
                 _
          L    _/     H    H   H    L   
                 _
          H    _/     H    H   H    H  
                
          X     L     H    H   X    qo 
          
          X     X     L    H   X    L

          X     X     H    L   X    H

          X     X     L    L   X    illegal 

          ----------------------------- 
*/
`celldefine
`timescale 1ns / 100ps
module dffe (q, d, clk, clrn, ena, prn);
	parameter size =1;
	input
		d,
		clrn,
		ena,
		prn,
		clk;
	output
		q;

	reg r_q;
	buf (q, r_q);

  	always @(posedge clk)
		if (ena) r_q = d;

  	always @(clrn or prn)
    	if (clrn == 0) 
        	assign r_q = 0;
    	else if (prn == 0)
            assign r_q = 1;
    	else
        	deassign r_q;

specify

	// Synthesis parameters
	`ifdef SYNTH
     	specparam area = 1;
     	specparam capacitance$clk = 1;
     	specparam capacitance$clrn = 1;
     	specparam capacitance$d = 1;
     	specparam capacitance$prn = 1;
     	specparam capacitance$ena = 1;
	`endif

    // Timing Checks
    $hold(posedge clk,d,1.0);
    $setup(d,posedge clk,1.0);

    // Path Delays
       if (clrn && prn && ena) 
            (posedge clk => (q +: d)) = (1, 1);

       (negedge clrn => (q +: 1'b0)) = (1, 1);
       (negedge prn => (q +: 1'b1)) = (1, 1);

endspecify
endmodule
`endcelldefine
